﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="PatientWorkflows.aspx.cs" Inherits="PatientWorkflows" MasterPageFile = "~/Registry.master" MaintainScrollPositionOnPostback = "true" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
  <script src="scripts/scrollsaver.js" type="text/javascript"></script>
    <link type = "text/css" href ="styles/StyleSheet.css"/>
    <style type="text/css">
        .style1
        {
            width: 100%;
        }
        .style2
        {
            width: 110px;
        }
        .style3
        {
        }
        .style4
        {
            width: 8px;
        }
        .style6
        {
            width: 110px;
        }
        .style8
        {
            width: 200px;
        }
        .style9
        {
            width: 100px;
        }
        .style10
        {
            width: 110px;
        }
        .style11
        {
            width: 250px;
        }
        .style12
        {
            width: 250px;
        }
        .style13
        {
            width: 200px;
        }
        .style14
        {
            width: 120px;
        }
        
        .one fieldset 
        {                  
            background-color: #fefbd2;                          
            position : relative;
            margin-top:1em;
            padding-top:.75em;                
        }

        .one fieldset legend 
        {   
            position: absolute;
            top: -.5em;
            left: .5em;
        }
        
        .two fieldset 
        {
            background-color: #FFFFFF;            
            position : relative;            
            margin-top:1em;
            padding-top:.75em;            
        }
        
        .two fieldset legend
        {
            position: absolute;
            top: -.5em;
            left: .5em;           
        }
               
    </style>          
</asp:Content> 


<asp:Content ID="Content2" ContentPlaceHolderID = "ContentPlaceHolder" Runat="Server">
    <asp:ValidationSummary ID="ValidationSummaryPatientWorflows" runat="server"   
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ShowMessageBox="True" />
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text="Patients > Patient Lookup > Workflows > " />
    </div>    

     <asp:Repeater ID = "EFRPatientReferrals" runat = "server"  
        DataSourceID = "ObjectDataSourcePatientReferrals" 
        OnItemCommand = "EFRPatientReferrals_ItemCommand"
        OnItemCreated = "EFRPatientReferrals_ItemCreated"
        OnItemDataBound = "EFRPatientReferrals_DataBound">
        
        <HeaderTemplate>
            <table id="PatientReferralResults" cellspacing="-2" cellpadding="2">
        </HeaderTemplate> 
        
        <SeparatorTemplate> 
            <tr>
                <td>
                    &nbsp; 
                </td>
            </tr>
        </SeparatorTemplate> 
        <ItemTemplate>      
            <asp:HiddenField ID="ReferralIDField" runat="server"  Value='<%# Eval("ReferralId") %>' />
            <asp:HiddenField ID="HiddenFieldPatientId" runat="server" Value='<%# Eval("PatientId") %>' />
            <tr>
                <td class="style3">      
                    <asp:Panel 
                        ID = "ReferralWorkflowsPanel" 
                        runat = "server"  
                        GroupingText = '<%# "Referral" + "&nbsp;#&nbsp;" 
                            + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ReferralId")), false) 
                            + "&nbsp;(" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ReferralStatus")), false) + ")&nbsp;"  %>' 
                        Width = "100%" 
                        CssClass = "one" >
                        
                        <table border = "0">

                        <tr>
                            <td style = "width:450px" align = "left" colspan = "2">                                                 
                                <asp:Label 
                                    SkinID="DataLabel" 
                                    ID="LabelforImagingReviewed" 
                                    runat="server" 
                                    AssociatedControlID="LabelImagingReviewedHeader" 
                                    ToolTip="Date Imaging Reviewed by Staff" >
                                    Date Imaging Reviewed by Staff (mm/dd/yyyy):&nbsp;&nbsp;
                                </asp:Label>
                                <asp:Label 
                                    SkinID="DataLabel" 
                                    ID="LabelImagingReviewedHeader" 
                                    runat="server" 
                                    ToolTip="Date Imaging Reviewed by Staff" 
                                    Text='<%# ImagingDateReviewed %>'>
                                </asp:Label>                
                            </td> 
                        </tr>
                        <tr>
                            <td style = "width:450px" align = "left" colspan = "2">                                                 
                                <asp:Label 
                                    SkinID="DataLabel" 
                                    ID="LabelForFragmentVerified" 
                                    runat="server" 
                                    AssociatedControlID="LabelFragmentVerifiedHeader" 
                                    ToolTip="Fragment Verified" >
                                    Fragment Verified:&nbsp;&nbsp;
                                </asp:Label>
                                <asp:Label 
                                    SkinID="DataLabel" 
                                    ID="LabelFragmentVerifiedHeader" 
                                    runat="server" 
                                    ToolTip="Was a Fragment Verified?" 
                                    Text='<%# ImagingFragmentVerified %>'>
                                </asp:Label>                    
                            </td> 
                        </tr>

                        <tr>
                            <td style = "width:450px" align = "left" colspan = "2">                                                 
                                <asp:Label SkinID="DataLabel" runat="server" ID="labelReferralFollowUps"                                    
                                    Text = '<%#AntiXssEncoder.HtmlEncode(Convert.ToString(BioFollowUpText(Eval("BioFollowUps"))), false) %>'
                                Width = "450px"  >                                
                            </asp:Label>
                            </td> 
                        </tr>
                        <tr>
                            <td>                           
                            <asp:Label SkinID="DataLabel" runat="server" ID="labelReferralContactLogs" 
                                Text='<%# SelectContactText(Eval("ContactLogsCount")) %>' 
                                Width = "250px" >
                                
                            </asp:Label>
                                                     
                            </td>
                            <td style = "width:70%" align = "left"> 
                                <table>
                                <tr>
                                <td><asp:Button ID = "btnReferrals" 
                                    CommandName = "Referral" 
                                    runat = "server" 
                                    Text = "Select Referral" />
                                </td>
                                <td><asp:Button ID = "btnContacts" 
                                    CommandName = "ContactLogs" 
                                    runat = "server" 
                                    Text = "Select Contact Entries" />   
                                </td>
                                </tr>
                                <tr>
                                <td><asp:Button ID = "ButtonViewDoDFragmentRawData" 
                                    CommandName = "ViewDoDFragmentRawData" 
                                    Enabled="false" 
                                    runat = "server" 
                                    Text = "Display Source DoD Fragment Data" />      
                                </td>
                                <td><asp:Button ID = "ButtonViewDoDFragment" 
                                    CommandName = "ViewDoDFragment" 
                                    Enabled="false" 
                                    runat = "server" 
                                    Text = "Enter / View DoD Fragment Data" />   
                                </td>
                                </tr>
                                </table>

                             </td>                                                                 
                        </tr>
                        <tr>
                            <td colspan = "2">
                                <asp:Label SkinID="DataLabel" ID = "labelNoWorkflows" Text = "&nbsp;This referral has no workflows" runat = "server"></asp:Label>      
                            </td>
                        
                        </tr>
                        <tr>
                            <td colspan = "2">
                                <asp:ObjectDataSource 
                                    ID = "ObjectDataSourceReferralWorkflows" 
                                    runat = "server" 
                                    SelectMethod = "GetCasesByReferralId"
                                    TypeName = "VeteransAffairs.Registries.BusinessManager.WorkflowManager">
                                     <SelectParameters>
                                        <asp:Parameter Name="referralId" Type="Int32"  />
                                        
                                     </SelectParameters>    
                                </asp:ObjectDataSource>
                                <asp:Repeater ID = "ReferralCases" runat = "server" DataSourceID = "ObjectDataSourceReferralWorkflows" 
                                OnItemDataBound = "ReferralCases_DataBound">                     
                                                                   
                                    <HeaderTemplate>
                                        <table id="PatientReferralResults" cellspacing="-2" cellpadding="1" width = "100%">           
                                    </HeaderTemplate> 
                                    
                                    <ItemTemplate>
                                        <asp:HiddenField ID="CaseIDField" runat="server" 
                                                Value='<%# Eval("CaseId") %>' />  
                                        <asp:HiddenField ID="CaseTypeIDField" runat="server" 
                                                Value='<%# Eval("CaseTypeId") %>' />
                                        <tr>
                                            <td>
                     
                                            <asp:Panel 
                                                ID = "ReferralCasesPanel" 
                                                runat = "server" 
                                                GroupingText = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CaseType")), false) 
                                                    + "&nbsp;#&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CaseId")), false) 
                                                    + "&nbsp;(" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CaseStatus")), false) + ")&nbsp;"  %>' 
                                                Width = "100%" 
                                                CssClass = "two">   
                                            <table border = "0" cellpadding = "0">
                                            <tr>
                                                <td>
                                                
                                                    <asp:ObjectDataSource ID = "ObjectDataSourceActivities" 
                                                        runat = "server" 
                                                        SelectMethod = "SelectByCaseId"
                                                        TypeName = "VeteransAffairs.Registries.BusinessManager.WorkflowCaseManager">
                                                        <SelectParameters>
                                                            <asp:Parameter Name="caseId" Type="Int32"  />
                                                            <asp:Parameter Name="caseTypeId" Type="Int32"  />
                                                        </SelectParameters> 
                                                    </asp:ObjectDataSource>

                                                   <asp:GridView 
                                                        ID = "GridViewReferralActivities" 
                                                        runat = "server" 
                                                        DataSourceID = "ObjectDataSourceActivities" 
                                                        SkinID = "Unsortable"  
                                                        AllowPaging = "false" 
                                                        AutoGenerateColumns = "False"  
                                                        DataKeyNames="CaseActivityId, CaseActivityTypeId" 
                                                        AllowSorting="false" 
                                                        OnRowCommand = "ReferralActivities_RowCommand" >
                                                        <EmptyDataTemplate>
                                                            No data to display
                                                        
                                                        </EmptyDataTemplate> 
                                                        <Columns> 
                                                            <asp:TemplateField HeaderText = "Stage" ItemStyle-Width = "130px" >
                                                            <ItemTemplate>
                                                                <asp:Label 
                                                                    SkinID="DataLabel" 
                                                                    ID = "CaseActivityType" 
                                                                    runat = "server" 
                                                                    Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CaseActivityType")), false) %>'/>
                                                            </ItemTemplate>    
                                                            </asp:TemplateField>
                                                            <asp:TemplateField HeaderText = "Status" ItemStyle-Width = "130px">
                                                            <ItemTemplate>
                                                                <asp:Label 
                                                                    SkinID="DataLabel" 
                                                                    ID = "CaseActivityStatus" 
                                                                    runat = "server" 
                                                                    Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CaseActivityStatus")), false) %>'/>
                                                            </ItemTemplate>    
                                                            </asp:TemplateField>
                                                            <asp:TemplateField HeaderText = "Last Updated" ItemStyle-Width = "100px" >
                                                            <ItemTemplate>
                                                                <asp:Label SkinID="DataLabel" 
                                                                    ID = "LastUpdatedDate" 
                                                                    runat = "server" 
                                                                    Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("UpdatedDate")), false) %>'/>
                                                            </ItemTemplate>    
                                                            </asp:TemplateField>                                             
                                                            <asp:TemplateField ItemStyle-HorizontalAlign = "Center" ItemStyle-Width = "75px">
                                                            <ItemTemplate>
                                                                <asp:Button 
                                                                    ID = "SelectActivity" 
                                                                    runat = "server" 
                                                                    Text = "Select" 
                                                                    Visible = '<%# Eval("CaseActivityExists") %>' 
                                                                    CommandName = "ActivityDetails" 
                                                                    CommandArgument = '<%# Container.DataItemIndex %>'/> 
                                                            </ItemTemplate>    
                                                            </asp:TemplateField>
                                                
                                                        </Columns>
                                                    </asp:GridView> 
                                                </td>
                                            
                                            </tr>
                                            
                                            </table>

                                            </asp:Panel>
                                            </td>
                                        </tr>
                                           
                                    </ItemTemplate> 
                                     
                                    <FooterTemplate>
            
                                        <tr>
                                            <td align = "left" >
                                                &nbsp;
                                            </td> 
                                        
                                        </tr>
                                    </table> 
                                    </FooterTemplate>

                                </asp:Repeater>                           
                            </td>                                             
                        
                        </tr>
                                                
                        </table>
                        
                    </asp:Panel> 
                </td> 
            </tr> 
        </ItemTemplate> 
        
        <FooterTemplate>
            
            <tr>
                <td align = "left" >
                    &nbsp;
                </td> 
                
            </tr>
        </table> 
        </FooterTemplate>


    </asp:Repeater> 
     <asp:ObjectDataSource ID="ObjectDataSourcePatientReferrals" runat="server"         
        SelectMethod="SelectByPatientId" 
        TypeName="VeteransAffairs.Registries.BusinessManager.ReferralManager">
        <SelectParameters>
            <asp:QueryStringParameter QueryStringField = "patientId" Direction = "Input" Name = "id" /> 
        </SelectParameters>       
     </asp:ObjectDataSource>
     
     <p>
         <asp:Button runat = "server" Text = "Cancel" Width = "130px" ID = "CancelButton" OnClick="CancelButton_OnClick" UseSubmitBehavior = "false" />
     </p>
         
</asp:Content> 